//
//  GHUserSettings.h
//  Garmin Health
//
//  Created by Johnson, Garrett on 6/29/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import "GHUserGoal.h"
#import "GHLanguage.h"

/**
 *  User gender
 */
typedef NS_ENUM(uint8_t, GHUserGender){
    /** Female */
    GHUserGenderFemale,
    /** Male */
    GHUserGenderMale
};


#pragma mark -
/** Settings object for profile information that can apply to multiple devices. */
@interface GHUserSettings : NSObject<NSCoding, NSCopying>

/**
 *  User age, must be greater than 0
 *  Value is an integer.
 */
@property (nonatomic) NSNumber *age;

/**
 *  User weight, in kg, must be greater than 0
 *  Value is a double.
 */
@property (nonatomic) NSNumber *weight;

/**
 *  User height, in m, must be greater than 0
 *  Value is a double.
 */
@property (nonatomic) NSNumber *height;

/**
 *  User gender. GHUserGender
 */
@property (nonatomic) GHUserGender gender;

/**
 *  User activity level. Values are used to calculate the number of calories burned during an activity and correspond
 *  to the number of minutes of training per week where 0 is no training and 10 is more that 15 hours a week.
 *  Value is an integer.
 *  @note Only used in the standard SDK
 */
@property (nonatomic) NSNumber *activityLevel;

/**
 *  Optional step length, in m, for walking. Set to 0 for automatic mode.
 *  Value is a double.
 *  @note Only used in the standard SDK
 */
@property (nonatomic) NSNumber *walkingStepLength;

/**
 *  Optional step length, in m, for running. Set to 0 for automatic mode.
 *  Value is a double.
 *  @note Only used in the standard SDK
 */
@property (nonatomic) NSNumber *runningStepLength;

/**
 *  Language to use on the watch.
 *  @note Only used in the standard SDK
 */
@property (nonatomic) GHLanguage *language;

/**
 *  Optional user set goals. Refer to GHUserGoal for additional information.
 *  @note Only used in the standard SDK
 */
@property (nonatomic) NSArray<GHUserGoal*>*goals;

/**
 *  Start time for sleeping.
 *  Value is the number of seconds into the day since local 00:00:00
 *  @note Only used in the standard SDK
 */
@property (nonatomic) NSNumber *startSleepTime;

/**
 *  End time for sleeping.
 *  Value is the number of seconds into the day since local 00:00:00
 *  @note Only used in the standard SDK
 */
@property (nonatomic) NSNumber *endSleepTime;

#pragma mark - Methods
/**
 *  Prefered initialization method.
 *  @param settings  Setting to use.
 */
- (instancetype) initWithSettings:(GHUserSettings *)settings;


@end
